/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.Map;
import java.util.function.BiFunction;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.From;
import org.codefilarete.stalactite.query.model.FromAware;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.GroupByAware;
import org.codefilarete.stalactite.query.model.GroupByChain;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.HavingAware;
import org.codefilarete.stalactite.query.model.JoinChain;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.LimitChain;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.OrderByAware;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.SelectChain;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.query.model.UnionAware;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.query.model.WhereAware;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.reflect.MethodDispatcher;

public class Query
implements FromAware,
WhereAware,
HavingAware,
OrderByAware,
LimitAware<FluentLimitClause>,
QueryProvider<Query>,
QueryStatement,
UnionAware {
    private final FluentSelectClause select;
    private final Select selectDelegate;
    private final FluentFromClause from;
    private final From fromDelegate;
    private final FluentWhereClause where;
    private final Where whereDelegate;
    private final FluentGroupByClause groupBy;
    private final GroupBy groupByDelegate;
    private final FluentHavingClause having;
    private final Having havingDelegate;
    private final FluentOrderByClause orderBy;
    private final OrderBy orderByDelegate;
    private final FluentLimitClause limit;
    private final Limit limitDelegate;

    public Query() {
        this(null);
    }

    public Query(Fromable rootTable) {
        this(new Select(), new From(rootTable), new Where(), new GroupBy(), new Having(), new OrderBy(), new Limit());
    }

    public Query(Select selectDelegate, From fromDelegate, Where whereDelegate, GroupBy groupByDelegate, Having havingDelegate, OrderBy orderByDelegate, Limit limitDelegate) {
        this.selectDelegate = selectDelegate;
        this.select = (FluentSelectClause)new MethodReferenceDispatcher().redirect(SelectChain.class, (Object)this.selectDelegate, true).redirect(FluentSelectClause::add, (BiFunction)new BiFunction<String, Class, FluentSelectClauseAliasableExpression>(){

            @Override
            public FluentSelectClauseAliasableExpression apply(String s, Class aClass) {
                SelectChain.AliasableExpression<Select> add = Query.this.selectDelegate.add(s, aClass);
                return (FluentSelectClauseAliasableExpression)new MethodDispatcher().redirect(SelectChain.Aliasable.class, alias -> {
                    add.as(alias);
                    return null;
                }, true).fallbackOn((Object)Query.this.select).build(FluentSelectClauseAliasableExpression.class);
            }
        }).redirect(FromAware.class, (Object)this).redirect(QueryProvider.class, (Object)this).build(FluentSelectClause.class);
        this.fromDelegate = fromDelegate;
        this.from = (FluentFromClause)new MethodDispatcher().redirect(JoinChain.class, (Object)this.fromDelegate, true).redirect(WhereAware.class, (Object)this).redirect(GroupByAware.class, (Object)this).redirect(OrderByAware.class, (Object)this).redirect(LimitAware.class, (Object)this).redirect(QueryProvider.class, (Object)this).build(FluentFromClause.class);
        this.whereDelegate = whereDelegate;
        this.where = (FluentWhereClause)new MethodDispatcher().redirect(CriteriaChain.class, (Object)this.whereDelegate, true).redirect(Iterable.class, (Object)whereDelegate).redirect(GroupByAware.class, (Object)this).redirect(OrderByAware.class, (Object)this).redirect(LimitAware.class, (Object)this).redirect(QueryProvider.class, (Object)this).redirect(UnionAware.class, (Object)this).build(FluentWhereClause.class);
        this.groupByDelegate = groupByDelegate;
        this.groupBy = (FluentGroupByClause)new MethodDispatcher().redirect(GroupByChain.class, (Object)this.groupByDelegate, true).redirect(HavingAware.class, (Object)this).redirect(OrderByAware.class, (Object)this).redirect(LimitAware.class, (Object)this).redirect(QueryProvider.class, (Object)this).redirect(UnionAware.class, (Object)this).build(FluentGroupByClause.class);
        this.havingDelegate = havingDelegate;
        this.having = (FluentHavingClause)new MethodDispatcher().redirect(CriteriaChain.class, (Object)this.havingDelegate, true).redirect(OrderByAware.class, (Object)this).redirect(LimitAware.class, (Object)this).redirect(QueryProvider.class, (Object)this).redirect(UnionAware.class, (Object)this).build(FluentHavingClause.class);
        this.orderByDelegate = orderByDelegate;
        this.orderBy = (FluentOrderByClause)new MethodDispatcher().redirect(OrderByChain.class, (Object)this.orderByDelegate, true).redirect(LimitAware.class, (Object)this).redirect(QueryProvider.class, (Object)this).redirect(UnionAware.class, (Object)this).build(FluentOrderByClause.class);
        this.limitDelegate = limitDelegate;
        this.limit = (FluentLimitClause)new MethodDispatcher().redirect(LimitChain.class, (Object)this.limitDelegate, true).redirect(QueryProvider.class, (Object)this).redirect(UnionAware.class, (Object)this).build(FluentLimitClause.class);
    }

    public FluentSelectClause getSelect() {
        return this.select;
    }

    public Select getSelectDelegate() {
        return this.selectDelegate;
    }

    public JoinChain getFrom() {
        return this.from;
    }

    public From getFromDelegate() {
        return this.fromDelegate;
    }

    public FluentWhereClause getWhere() {
        return this.where;
    }

    public Where getWhereDelegate() {
        return this.whereDelegate;
    }

    public GroupBy getGroupByDelegate() {
        return this.groupByDelegate;
    }

    public Having getHavingDelegate() {
        return this.havingDelegate;
    }

    public OrderBy getOrderByDelegate() {
        return this.orderByDelegate;
    }

    public Limit getLimitDelegate() {
        return this.limitDelegate;
    }

    public KeepOrderSet<Selectable<?>> getColumns() {
        return this.selectDelegate.getColumns();
    }

    @Override
    public Map<Selectable<?>, String> getAliases() {
        return this.selectDelegate.getAliases();
    }

    public FluentSelectClause select(Iterable<? extends Selectable<?>> selectables) {
        selectables.forEach(this.selectDelegate::add);
        return this.select;
    }

    public FluentSelectClause select(Selectable<?> expression, Selectable<?> ... expressions) {
        this.selectDelegate.add((Selectable)expression, (Selectable[])expressions);
        return this.select;
    }

    public FluentSelectClauseAliasableExpression select(String expression, Class<?> javaType) {
        SelectChain.AliasableExpression<Select> add = this.selectDelegate.add(expression, javaType);
        return (FluentSelectClauseAliasableExpression)new MethodDispatcher().redirect(SelectChain.Aliasable.class, alias -> {
            add.as(alias);
            return null;
        }, true).redirect(FluentSelectClause.class, (Object)this.select).build(FluentSelectClauseAliasableExpression.class);
    }

    public FluentSelectClause select(Selectable<?> column, String alias) {
        this.selectDelegate.add((Selectable)column, alias);
        return this.select;
    }

    public FluentSelectClause select(Selectable<?> col1, String alias1, Selectable<?> col2, String alias2) {
        this.selectDelegate.add(col1, alias1, col2, alias2);
        return this.select;
    }

    public FluentSelectClause select(Selectable<?> col1, String alias1, Selectable<?> col2, String alias2, Selectable<?> col3, String alias3) {
        this.selectDelegate.add(col1, alias1, col2, alias2, col3, alias3);
        return this.select;
    }

    public FluentSelectClause select(Map<? extends Selectable<?>, String> aliasedColumns) {
        this.selectDelegate.add((Map)aliasedColumns);
        return this.select;
    }

    @Override
    public FluentFromClause from(Fromable leftTable, Fromable rightTable, String joinCondition) {
        this.fromDelegate.setRoot(leftTable).innerJoin(rightTable, joinCondition);
        return this.from;
    }

    @Override
    public FluentFromClause from(Fromable leftTable) {
        this.fromDelegate.setRoot(leftTable);
        return this.from;
    }

    @Override
    public FluentFromClause from(QueryProvider<?> query, String alias) {
        this.fromDelegate.setRoot(query.getQuery().asPseudoTable(), alias);
        return this.from;
    }

    @Override
    public FluentFromClause from(Fromable leftTable, String tableAlias) {
        this.fromDelegate.setRoot(leftTable, tableAlias);
        return this.from;
    }

    @Override
    public FluentFromClause from(Fromable leftTable, String leftTableAlias, Fromable rightTable, String rightTableAlias, String joinCondition) {
        this.fromDelegate.setRoot(leftTable).innerJoin(rightTable, rightTableAlias, joinCondition);
        return this.from;
    }

    @Override
    public <I> FluentFromClause from(JoinLink<?, I> leftColumn, JoinLink<?, I> rightColumn) {
        this.fromDelegate.setRoot((Fromable)leftColumn.getOwner()).innerJoin((JoinLink)leftColumn, (JoinLink)rightColumn);
        return this.from;
    }

    @Override
    public <O> FluentWhereClause where(Column<?, O> column, CharSequence condition) {
        this.whereDelegate.and(new ColumnCriterion(column, condition));
        return this.where;
    }

    @Override
    public <O> FluentWhereClause where(Column<?, O> column, ConditionalOperator<? super O, ?> condition) {
        this.whereDelegate.and(new ColumnCriterion(column, condition));
        return this.where;
    }

    @Override
    public FluentWhereClause where(Criteria criteria) {
        this.whereDelegate.and(criteria);
        return this.where;
    }

    @Override
    public FluentWhereClause where(Object ... criteria) {
        this.whereDelegate.and(criteria);
        return this.where;
    }

    @Override
    public FluentGroupByClause groupBy(Column column, Column ... columns) {
        this.groupByDelegate.add(column, columns);
        return this.groupBy;
    }

    @Override
    public FluentGroupByClause groupBy(String column, String ... columns) {
        this.groupByDelegate.add(column, columns);
        return this.groupBy;
    }

    @Override
    public FluentHavingClause having(Column column, String condition) {
        this.havingDelegate.and(column, condition);
        return this.having;
    }

    @Override
    public FluentHavingClause having(Object ... columns) {
        this.havingDelegate.and(columns);
        return this.having;
    }

    @Override
    public Query getQuery() {
        return this;
    }

    public FluentOrderByClause orderBy() {
        return this.orderBy;
    }

    @Override
    public FluentOrderByClause orderBy(Column column, OrderByChain.Order order) {
        this.orderByDelegate.add((Selectable)column, order);
        return this.orderBy;
    }

    @Override
    public FluentOrderByClause orderBy(Column col1, OrderByChain.Order order1, Column col2, OrderByChain.Order order2) {
        this.orderByDelegate.add((Selectable)col1, order1, (Selectable)col2, order2);
        return this.orderBy;
    }

    @Override
    public FluentOrderByClause orderBy(Column col1, OrderByChain.Order order1, Column col2, OrderByChain.Order order2, Column col3, OrderByChain.Order order3) {
        this.orderByDelegate.add((Selectable)col1, order1, (Selectable)col2, order2, (Selectable)col3, order3);
        return this.orderBy;
    }

    @Override
    public FluentOrderByClause orderBy(String column, OrderByChain.Order order) {
        this.orderByDelegate.add(column, order);
        return this.orderBy;
    }

    @Override
    public FluentOrderByClause orderBy(String col1, OrderByChain.Order order1, String col2, OrderByChain.Order order2) {
        this.orderByDelegate.add(col1, order1, col2, order2);
        return this.orderBy;
    }

    @Override
    public FluentOrderByClause orderBy(String col1, OrderByChain.Order order1, String col2, OrderByChain.Order order2, String col3, OrderByChain.Order order3) {
        this.orderByDelegate.add(col1, order1, col2, order2, col3, order3);
        return this.orderBy;
    }

    @Override
    public FluentOrderByClause orderBy(Column column, Column ... columns) {
        this.orderByDelegate.add((Selectable)column, columns);
        return this.orderBy;
    }

    @Override
    public FluentOrderByClause orderBy(String column, String ... columns) {
        this.orderByDelegate.add(column, columns);
        return this.orderBy;
    }

    @Override
    public FluentLimitClause limit(int value) {
        this.limitDelegate.setCount(value);
        return this.limit;
    }

    @Override
    public FluentLimitClause limit(int value, Integer offset) {
        this.limitDelegate.setCount(value, offset);
        return this.limit;
    }

    @Override
    public Union unionAll(QueryProvider<Query> query) {
        return new Union(this, query.getQuery());
    }

    public static interface FluentLimitClause
    extends LimitChain<FluentLimitClause>,
    UnionAware,
    QueryProvider<Query> {
    }

    public static interface FluentOrderByClause
    extends OrderByChain<FluentOrderByClause>,
    LimitAware<FluentLimitClause>,
    UnionAware,
    QueryProvider<Query> {
    }

    public static interface FluentHavingClause
    extends CriteriaChain<FluentHavingClause>,
    OrderByAware,
    LimitAware<FluentLimitClause>,
    UnionAware,
    QueryProvider<Query> {
    }

    public static interface FluentGroupByClause
    extends GroupByChain<FluentGroupByClause>,
    HavingAware,
    OrderByAware,
    LimitAware<FluentLimitClause>,
    UnionAware,
    QueryProvider<Query> {
    }

    public static interface FluentWhereClause
    extends CriteriaChain<FluentWhereClause>,
    GroupByAware,
    OrderByAware,
    LimitAware<FluentLimitClause>,
    UnionAware,
    QueryProvider<Query> {
    }

    public static interface FluentFromClause
    extends JoinChain<FluentFromClause>,
    WhereAware,
    GroupByAware,
    OrderByAware,
    LimitAware<FluentLimitClause>,
    QueryProvider<Query> {
    }

    public static interface FluentSelectClauseAliasableExpression
    extends SelectChain.AliasableExpression<FluentSelectClause>,
    FluentSelectClause {
        public FluentSelectClause as(String var1);
    }

    public static interface FluentSelectClause
    extends SelectChain<FluentSelectClause>,
    FromAware,
    QueryProvider<Query> {
        public FluentSelectClauseAliasableExpression add(String var1, Class<?> var2);
    }
}

